/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.datagen;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mrthomas20121.tinkers_reforged.datagen.ReforgedMaterials;
import mrthomas20121.tinkers_reforged.init.CastType;
import mrthomas20121.tinkers_reforged.init.TinkersReforgedBlocks;
import mrthomas20121.tinkers_reforged.init.TinkersReforgedFluids;
import mrthomas20121.tinkers_reforged.init.TinkersReforgedItems;
import mrthomas20121.tinkers_reforged.init.TinkersReforgedTags;
import mrthomas20121.tinkers_reforged.item.CastObject;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.ICommonRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IToolRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelBuilder;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.partbuilder.PartRecipeBuilder;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.data.Byproduct;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.world.TinkerWorld;

public class ReforgedRecipes
extends RecipeProvider
implements IConditionBuilder,
IMaterialRecipeHelper,
IToolRecipeHelper,
ISmelteryRecipeHelper,
ICommonRecipeHelper {
    public ReforgedRecipes(DataGenerator gen) {
        super(gen);
    }

    protected void m_176531_(@Nonnull Consumer<FinishedRecipe> consumer) {
        String materialFolder = "materials/";
        String meltingFolder = "smeltery/melting/";
        String gemFolder = meltingFolder + "/gem/";
        String castingFolder = "smeltery/casting/";
        String castFolder = "smeltery/casts/";
        String alloyFolder = "smeltery/alloy/";
        String toolFolder = "tools/building/";
        String partFolder = "tools/parts/";
        this.blockIngotNuggetCompression(consumer, "aluminum", ((Block)TinkersReforgedBlocks.aluminum_block.get()).m_5456_(), (Item)TinkersReforgedItems.aluminum_ingot.get(), (Item)TinkersReforgedItems.aluminum_nugget.get());
        this.blockIngotNuggetCompression(consumer, "duralumin", ((Block)TinkersReforgedBlocks.duralumin_block.get()).m_5456_(), (Item)TinkersReforgedItems.duralumin_ingot.get(), (Item)TinkersReforgedItems.duralumin_nugget.get());
        this.blockIngotNuggetCompression(consumer, "electrical_copper", ((Block)TinkersReforgedBlocks.electrical_copper_block.get()).m_5456_(), (Item)TinkersReforgedItems.electrical_copper_ingot.get(), (Item)TinkersReforgedItems.electrical_copper_nugget.get());
        this.blockIngotNuggetCompression(consumer, "lavium", ((Block)TinkersReforgedBlocks.lavium_block.get()).m_5456_(), (Item)TinkersReforgedItems.lavium_ingot.get(), (Item)TinkersReforgedItems.lavium_nugget.get());
        this.blockIngotNuggetCompression(consumer, "qivium", ((Block)TinkersReforgedBlocks.qivium_block.get()).m_5456_(), (Item)TinkersReforgedItems.qivium_ingot.get(), (Item)TinkersReforgedItems.qivium_nugget.get());
        this.blockIngotNuggetCompression(consumer, "gausum", ((Block)TinkersReforgedBlocks.gausum_block.get()).m_5456_(), (Item)TinkersReforgedItems.gausum_ingot.get(), (Item)TinkersReforgedItems.gausum_nugget.get());
        this.blockIngotNuggetCompression(consumer, "felsteel", ((Block)TinkersReforgedBlocks.felsteel_block.get()).m_5456_(), (Item)TinkersReforgedItems.felsteel_ingot.get(), (Item)TinkersReforgedItems.felsteel_nugget.get());
        this.blockIngotNuggetCompression(consumer, "kepu", ((Block)TinkersReforgedBlocks.kepu_block.get()).m_5456_(), (Item)TinkersReforgedItems.kepu_ingot.get(), (Item)TinkersReforgedItems.kepu_nugget.get());
        this.blockIngotNuggetCompression(consumer, "chorus_metal", ((Block)TinkersReforgedBlocks.chorus_metal_block.get()).m_5456_(), (Item)TinkersReforgedItems.chorus_metal_ingot.get(), (Item)TinkersReforgedItems.chorus_metal_nugget.get());
        this.blockIngotNuggetCompression(consumer, "durasteel", ((Block)TinkersReforgedBlocks.durasteel_block.get()).m_5456_(), (Item)TinkersReforgedItems.durasteel_ingot.get(), (Item)TinkersReforgedItems.durasteel_nugget.get());
        this.blockIngotNuggetCompression(consumer, "crusteel", ((Block)TinkersReforgedBlocks.crusteel_block.get()).m_5456_(), (Item)TinkersReforgedItems.crusteel_ingot.get(), (Item)TinkersReforgedItems.crusteel_nugget.get());
        this.blockIngotNuggetCompression(consumer, "wavy", ((Block)TinkersReforgedBlocks.wavy_block.get()).m_5456_(), (Item)TinkersReforgedItems.wavy_ingot.get(), (Item)TinkersReforgedItems.wavy_nugget.get());
        this.blockIngotNuggetCompression(consumer, "yokel", ((Block)TinkersReforgedBlocks.yokel_block.get()).m_5456_(), (Item)TinkersReforgedItems.yokel_ingot.get(), (Item)TinkersReforgedItems.yokel_nugget.get());
        this.metalCasting(consumer, TinkersReforgedFluids.duralumin, (ItemLike)TinkersReforgedBlocks.duralumin_block.get(), (ItemLike)TinkersReforgedItems.duralumin_ingot.get(), (ItemLike)TinkersReforgedItems.duralumin_nugget.get(), castingFolder, "duralumin");
        this.metalCasting(consumer, TinkersReforgedFluids.electrical_copper, (ItemLike)TinkersReforgedBlocks.electrical_copper_block.get(), (ItemLike)TinkersReforgedItems.electrical_copper_ingot.get(), (ItemLike)TinkersReforgedItems.electrical_copper_nugget.get(), castingFolder, "electrical_copper");
        this.metalCasting(consumer, TinkersReforgedFluids.lavium, (ItemLike)TinkersReforgedBlocks.lavium_block.get(), (ItemLike)TinkersReforgedItems.lavium_ingot.get(), (ItemLike)TinkersReforgedItems.lavium_nugget.get(), castingFolder, "lavium");
        this.metalCasting(consumer, TinkersReforgedFluids.qivium, (ItemLike)TinkersReforgedBlocks.qivium_block.get(), (ItemLike)TinkersReforgedItems.qivium_ingot.get(), (ItemLike)TinkersReforgedItems.qivium_nugget.get(), castingFolder, "qivium");
        this.metalCasting(consumer, TinkersReforgedFluids.gausum, (ItemLike)TinkersReforgedBlocks.gausum_block.get(), (ItemLike)TinkersReforgedItems.gausum_ingot.get(), (ItemLike)TinkersReforgedItems.gausum_nugget.get(), castingFolder, "gausum");
        this.metalCasting(consumer, TinkersReforgedFluids.felsteel, (ItemLike)TinkersReforgedBlocks.felsteel_block.get(), (ItemLike)TinkersReforgedItems.felsteel_ingot.get(), (ItemLike)TinkersReforgedItems.felsteel_nugget.get(), castingFolder, "felsteel");
        this.metalCasting(consumer, TinkersReforgedFluids.kepu, (ItemLike)TinkersReforgedBlocks.kepu_block.get(), (ItemLike)TinkersReforgedItems.kepu_ingot.get(), (ItemLike)TinkersReforgedItems.kepu_nugget.get(), castingFolder, "kepu");
        this.metalCasting(consumer, TinkersReforgedFluids.chorus_metal, (ItemLike)TinkersReforgedBlocks.chorus_metal_block.get(), (ItemLike)TinkersReforgedItems.chorus_metal_ingot.get(), (ItemLike)TinkersReforgedItems.chorus_metal_nugget.get(), castingFolder, "chorus_metal");
        this.metalCasting(consumer, TinkersReforgedFluids.durasteel, (ItemLike)TinkersReforgedBlocks.durasteel_block.get(), (ItemLike)TinkersReforgedItems.durasteel_ingot.get(), (ItemLike)TinkersReforgedItems.durasteel_nugget.get(), castingFolder, "durasteel");
        this.metalCasting(consumer, TinkersReforgedFluids.crusteel, (ItemLike)TinkersReforgedBlocks.crusteel_block.get(), (ItemLike)TinkersReforgedItems.crusteel_ingot.get(), (ItemLike)TinkersReforgedItems.crusteel_nugget.get(), castingFolder, "crusteel");
        this.metalCasting(consumer, TinkersReforgedFluids.yokel, (ItemLike)TinkersReforgedBlocks.wavy_block.get(), (ItemLike)TinkersReforgedItems.wavy_ingot.get(), (ItemLike)TinkersReforgedItems.wavy_nugget.get(), castingFolder, "wavy");
        this.metalCasting(consumer, TinkersReforgedFluids.yokel, (ItemLike)TinkersReforgedBlocks.yokel_block.get(), (ItemLike)TinkersReforgedItems.yokel_ingot.get(), (ItemLike)TinkersReforgedItems.yokel_nugget.get(), castingFolder, "yokel");
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.duralumin, TinkersReforgedFluids.duralumin, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.electrical_copper, TinkersReforgedFluids.electrical_copper, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.lavium, TinkersReforgedFluids.lavium, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.qivium, TinkersReforgedFluids.qivium, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.gausum, TinkersReforgedFluids.gausum, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.felsteel, TinkersReforgedFluids.felsteel, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.chorus_metal, TinkersReforgedFluids.chorus_metal, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.kepu, TinkersReforgedFluids.kepu, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.durasteel, TinkersReforgedFluids.durasteel, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.crusteel, TinkersReforgedFluids.crusteel, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.wavy, TinkersReforgedFluids.wavy, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)ReforgedMaterials.yokel, TinkersReforgedFluids.yokel, materialFolder);
        this.metalMelting(consumer, (Fluid)TinkersReforgedFluids.duralumin.get(), "duralumin", false, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(consumer, (Fluid)TinkersReforgedFluids.electrical_copper.get(), "electrical_copper", false, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(consumer, (Fluid)TinkersReforgedFluids.lavium.get(), "lavium", false, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(consumer, (Fluid)TinkersReforgedFluids.qivium.get(), "qivium", false, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(consumer, (Fluid)TinkersReforgedFluids.gausum.get(), "gausum", false, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(consumer, (Fluid)TinkersReforgedFluids.felsteel.get(), "felsteel", false, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(consumer, (Fluid)TinkersReforgedFluids.kepu.get(), "kepu", true, meltingFolder, false, new IByproduct[]{Byproduct.AMETHYST});
        this.metalMelting(consumer, (Fluid)TinkersReforgedFluids.chorus_metal.get(), "chorus_metal", false, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(consumer, (Fluid)TinkersReforgedFluids.crusteel.get(), "crusteel", false, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(consumer, (Fluid)TinkersReforgedFluids.wavy.get(), "wavy", false, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(consumer, (Fluid)TinkersReforgedFluids.yokel.get(), "yokel", false, meltingFolder, false, new IByproduct[0]);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.gausum, materialFolder, "gausum", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.duralumin, materialFolder, "duralumin", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.electrical_copper, materialFolder, "electrical_copper", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.lavium, materialFolder, "lavium", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.qivium, materialFolder, "qivium", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.felsteel, materialFolder, "felsteel", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.chorus_metal, materialFolder, "chorus_metal", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.kepu, materialFolder, "kepu", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.durasteel, materialFolder, "durasteel", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.crusteel, materialFolder, "crusteel", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.wavy, materialFolder, "wavy", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)ReforgedMaterials.yokel, materialFolder, "yokel", false);
        this.materialComposite(consumer, (MaterialVariantId)MaterialIds.cobalt, (MaterialVariantId)ReforgedMaterials.lavium, TinkerFluids.liquidSoul, false, 500, materialFolder + "lavium_");
        this.materialComposite(consumer, (MaterialVariantId)MaterialIds.cobalt, (MaterialVariantId)ReforgedMaterials.qivium, TinkerFluids.magma, true, 500, materialFolder + "qivium_");
        this.materialComposite(consumer, MaterialIds.bloodshroom, (MaterialVariantId)ReforgedMaterials.wavy, TinkerFluids.moltenObsidian, false, 500, materialFolder + "wavy_");
        this.metalComposite(consumer, TinkerMaterials.cobalt.getIngot(), (Item)TinkersReforgedItems.lavium_ingot.get(), TinkerFluids.liquidSoul, false, materialFolder, "lavium");
        this.metalComposite(consumer, TinkerMaterials.cobalt.getIngot(), (Item)TinkersReforgedItems.qivium_ingot.get(), TinkerFluids.magma, true, materialFolder, "qivium");
        this.metalComposite(consumer, (Block)TinkerWorld.bloodshroom.get(), (Item)TinkersReforgedItems.wavy_block.get(), TinkerFluids.moltenObsidian, false, materialFolder, "wavy_bloodshroom");
        this.metalComposite(consumer, Items.f_41954_, (Item)TinkersReforgedItems.wavy_ingot.get(), TinkerFluids.moltenObsidian, false, materialFolder, "wavy_crimson");
        this.metalComposite(consumer, Items.f_41955_, (Item)TinkersReforgedItems.wavy_ingot.get(), TinkerFluids.moltenObsidian, false, materialFolder, "wavy_warped");
        this.metalComposite(consumer, Items.f_42451_, (Item)TinkersReforgedItems.electrical_copper_dust.get(), TinkersReforgedFluids.blazing_copper, true, materialFolder, "electrical_copper");
        AlloyRecipeBuilder.alloy((Fluid)TinkersReforgedFluids.duralumin.get(), (int)450).addInput((Fluid)TinkerFluids.moltenCopper.get(), 90).addInput((Fluid)TinkerFluids.moltenAluminum.get(), 810).save(consumer, this.modResource(alloyFolder + "duralumin"));
        AlloyRecipeBuilder.alloy((Fluid)TinkersReforgedFluids.blazing_copper.get(), (int)810).addInput((Fluid)TinkerFluids.moltenCopper.get(), 810).addInput((Fluid)TinkerFluids.blazingBlood.get(), 1000).save(consumer, this.modResource(alloyFolder + "blazing_copper"));
        AlloyRecipeBuilder.alloy((Fluid)TinkersReforgedFluids.electrical_copper.get(), (int)180).addInput((Fluid)TinkersReforgedFluids.blazing_copper.get(), 180).addInput((Fluid)TinkersReforgedFluids.redstone.get(), 1000).save(consumer, this.modResource(alloyFolder + "electrical_copper"));
        AlloyRecipeBuilder.alloy((Fluid)TinkersReforgedFluids.gausum.get(), (int)180).addInput((Fluid)TinkersReforgedFluids.blazing_copper.get(), 180).addInput((Fluid)TinkerFluids.moltenDebris.get(), 180).addInput((Fluid)TinkersReforgedFluids.lapis.get(), 810).save(consumer, this.modResource(alloyFolder + "gausum"));
        AlloyRecipeBuilder.alloy((Fluid)TinkersReforgedFluids.felsteel.get(), (int)270).addInput((Fluid)TinkersReforgedFluids.blazing_copper.get(), 180).addInput((Fluid)TinkerFluids.moltenDebris.get(), 180).addInput((Fluid)TinkersReforgedFluids.duralumin.get(), 180).save(consumer, this.modResource(alloyFolder + "felsteel"));
        AlloyRecipeBuilder.alloy((Fluid)TinkersReforgedFluids.chorus_metal.get(), (int)90).addInput((Fluid)TinkersReforgedFluids.kepu.get(), 90).addInput((Fluid)TinkersReforgedFluids.chorus.get(), 90).addInput((Fluid)TinkersReforgedFluids.shulker.get(), 90).save(consumer, this.modResource(alloyFolder + "chorus_metal"));
        AlloyRecipeBuilder.alloy((Fluid)TinkersReforgedFluids.durasteel.get(), (int)90).addInput((Fluid)TinkerFluids.moltenEnder.get(), 250).addInput((Fluid)TinkerFluids.moltenDebris.get(), 90).save(consumer, this.modResource(alloyFolder + "durasteel"));
        AlloyRecipeBuilder.alloy((Fluid)TinkersReforgedFluids.proto_lava.get(), (int)1000).addInput((Fluid)TinkerFluids.moltenEnder.get(), 250).addInput((Fluid)TinkersReforgedFluids.chorus.get(), 90).addInput(FluidTags.f_13132_, 1000).save(consumer, this.modResource(alloyFolder + "proto_lava"));
        AlloyRecipeBuilder.alloy((Fluid)TinkersReforgedFluids.yokel.get(), (int)180).addInput((Fluid)TinkersReforgedFluids.kelp.get(), 250).addInput((Fluid)TinkerFluids.moltenAluminum.get(), 90).addInput((Fluid)TinkerFluids.moltenIron.get(), 90).save(consumer, this.modResource(alloyFolder + "yokel"));
        AlloyRecipeBuilder.alloy((Fluid)TinkersReforgedFluids.crusteel.get(), (int)270).addInput((Fluid)TinkerFluids.moltenCopper.get(), 90).addInput((Fluid)TinkerFluids.moltenDebris.get(), 90).addInput((Fluid)TinkerFluids.moltenAmethyst.get(), 90).save(consumer, this.modResource(alloyFolder + "crusteel"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41910_}), (FluidStack)new FluidStack((Fluid)TinkersReforgedFluids.kelp.get(), 250), (int)500, (int)30).save(consumer, new ResourceLocation("tinkers_reforged", "smeltery/molten_kelp"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.raw_aluminum.get()}), (FluidStack)new FluidStack((Fluid)TinkerFluids.moltenAluminum.get(), 90), (int)900, (int)50).save(consumer, new ResourceLocation("tinkers_reforged", "smeltery/raw_aluminum"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.raw_kepu.get()}), (FluidStack)new FluidStack((Fluid)TinkersReforgedFluids.kepu.get(), 90), (int)900, (int)50).addByproduct(new FluidStack((Fluid)TinkersReforgedFluids.chorus.get(), 45)).save(consumer, new ResourceLocation("tinkers_reforged", "smeltery/raw_kepu"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.STORAGE_BLOCKS_LAPIS), (Fluid)TinkersReforgedFluids.lapis.get(), (int)810).save(consumer, this.modResource(meltingFolder + "lapis_block"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_LAPIS), (Fluid)TinkersReforgedFluids.lapis.get(), (int)100).save(consumer, this.modResource(meltingFolder + "lapis_gem"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42748_}), (Fluid)TinkersReforgedFluids.shulker.get(), (int)45).save(consumer, this.modResource(meltingFolder + "shulker_shell"));
        EntityMeltingRecipeBuilder.melting((EntityIngredient)EntityIngredient.of((EntityType)EntityType.f_20521_), (FluidStack)new FluidStack((Fluid)TinkersReforgedFluids.shulker.get(), 90)).save(consumer, this.modResource(meltingFolder + "/entity/shulker"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42003_}), (Fluid)TinkersReforgedFluids.chorus.get(), (int)1000).save(consumer, this.modResource(meltingFolder + "chorus_flower"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42730_}), (Fluid)TinkersReforgedFluids.chorus.get(), (int)90).save(consumer, this.modResource(meltingFolder + "chorus_fruit"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42731_}), (Fluid)TinkersReforgedFluids.chorus.get(), (int)90).save(consumer, this.modResource(meltingFolder + "popped_chorus_fruit"));
        this.ingotCasting(consumer, TinkersReforgedFluids.chorus, (ItemLike)Items.f_42730_, castFolder + "chorus_fruit");
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.ORES_LAPIS), (Fluid)TinkersReforgedFluids.lapis.get(), (int)90, (float)2.0f).setOre(IMeltingContainer.OreRateType.GEM, new IMeltingContainer.OreRateType[0]).addByproduct(new FluidStack((Fluid)TinkerFluids.moltenDiamond.get(), 100)).save(consumer, this.modResource(gemFolder + "molten_lapis/ore"));
        ItemCastingRecipeBuilder.basinRecipe((ItemLike)Blocks.f_50060_).setFluidAndTime(TinkersReforgedFluids.lapis, true, 810).setSwitchSlots().save(consumer, this.modResource(castFolder + "lapis_block"));
        this.gemCasting(consumer, TinkersReforgedFluids.lapis, (ItemLike)Items.f_42534_, castFolder + "lapis_lazuli_gem");
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)TinkersReforgedItems.book.get())).setFluidAndTime(TinkerFluids.moltenAluminum, true, 90).setCast((ItemLike)Items.f_42517_, false).save(consumer, this.modResource(castFolder + "book"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(TinkersReforgedTags.Items.ALUMINUM_CASTS), (FluidStack)new FluidStack((Fluid)TinkerFluids.moltenAluminum.get(), 90), (int)700, (int)50).save(consumer, new ResourceLocation("tinkers_reforged", "smeltery/aluminum_from_cast"));
        MeltingFuelBuilder.fuel((FluidIngredient)FluidIngredient.of((FluidStack)new FluidStack((Fluid)TinkersReforgedFluids.blazing_copper.get(), 50)), (int)150, (int)1800).save(consumer, this.modResource("smeltery/fuel/blazing_copper"));
        MeltingFuelBuilder.fuel((FluidIngredient)FluidIngredient.of((FluidStack)new FluidStack((Fluid)TinkersReforgedFluids.proto_lava.get(), 50)), (int)100, (int)2500).save(consumer, this.modResource("smeltery/fuel/proto_lava"));
        this.createCast(consumer, CastType.ingot, (TagKey<Item>)Tags.Items.INGOTS, castFolder);
        this.createCast(consumer, CastType.nugget, (TagKey<Item>)Tags.Items.NUGGETS, castFolder);
        this.createCast(consumer, CastType.gem, (TagKey<Item>)Tags.Items.GEMS, castFolder);
        this.createCast(consumer, CastType.rod, (TagKey<Item>)Tags.Items.RODS, castFolder);
        this.createCast(consumer, CastType.plate, "plates", castFolder);
        this.createCast(consumer, CastType.gear, "gears", castFolder);
        this.createCast((Consumer<FinishedRecipe>)this.withCondition(consumer, new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition("forge:coins"))}), CastType.coin, "coins", castFolder);
        this.createCast((Consumer<FinishedRecipe>)this.withCondition(consumer, new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition("forge:wires"))}), CastType.wire, "wires", castFolder);
        this.createCast(consumer, CastType.broad_axe_head, (IMaterialItem)TinkerToolParts.broadAxeHead.get(), castFolder);
        this.createCast(consumer, CastType.broad_blade, (IMaterialItem)TinkerToolParts.broadBlade.get(), castFolder);
        this.createCast(consumer, CastType.hammer_head, (IMaterialItem)TinkerToolParts.hammerHead.get(), castFolder);
        this.createCast(consumer, CastType.large_plate, (IMaterialItem)TinkerToolParts.largePlate.get(), castFolder);
        this.createCast(consumer, CastType.pick_head, (IMaterialItem)TinkerToolParts.pickHead.get(), castFolder);
        this.createCast(consumer, CastType.repair_kit, (IMaterialItem)TinkerToolParts.repairKit.get(), castFolder);
        this.createCast(consumer, CastType.small_axe_head, (IMaterialItem)TinkerToolParts.smallAxeHead.get(), castFolder);
        this.createCast(consumer, CastType.small_blade, (IMaterialItem)TinkerToolParts.smallBlade.get(), castFolder);
        this.createCast(consumer, CastType.tool_binding, (IMaterialItem)TinkerToolParts.toolBinding.get(), castFolder);
        this.createCast(consumer, CastType.tool_handle, (IMaterialItem)TinkerToolParts.toolHandle.get(), castFolder);
        this.createCast(consumer, CastType.tough_handle, (IMaterialItem)TinkerToolParts.toughHandle.get(), castFolder);
        this.createCast(consumer, CastType.large_round_plate, (IMaterialItem)TinkersReforgedItems.LARGE_ROUND_PLATE.get(), castFolder);
        this.createCast(consumer, CastType.great_blade, (IMaterialItem)TinkersReforgedItems.GREAT_BLADE.get(), castFolder);
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)TinkersReforgedBlocks.raw_aluminum_block.get()), (int)1).m_126130_("XXX").m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)TinkersReforgedItems.raw_aluminum.get()).m_142409_("").m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.raw_aluminum.get()))).m_142700_(consumer, this.modResource("raw_aluminum_block"));
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)TinkersReforgedBlocks.raw_kepu_block.get()), (int)1).m_126130_("XXX").m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)TinkersReforgedItems.raw_kepu.get()).m_142409_("").m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.raw_kepu.get()))).m_142700_(consumer, this.modResource("raw_kepu_block"));
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)TinkersReforgedItems.raw_aluminum.get()), (int)9).m_126209_((ItemLike)TinkersReforgedBlocks.raw_aluminum_block.get()).m_142409_("").m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.raw_aluminum.get()))).m_142700_(consumer, this.modResource("raw_aluminum"));
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)TinkersReforgedItems.raw_kepu.get()), (int)9).m_126209_((ItemLike)TinkersReforgedBlocks.raw_kepu_block.get()).m_142409_("").m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.raw_kepu.get()))).m_142700_(consumer, this.modResource("raw_kepu"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(TinkersReforgedTags.Items.ALUMINUM_ORE), (ItemLike)((ItemLike)TinkersReforgedItems.aluminum_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.aluminum_ingot.get()))).m_142700_(consumer, this.modResource("aluminum_ingot_from_smelting_deepslate_aluminum_ore"));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_204132_(TinkersReforgedTags.Items.ALUMINUM_ORE), (ItemLike)((ItemLike)TinkersReforgedItems.aluminum_ingot.get()), (float)0.5f, (int)100).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.aluminum_ingot.get()))).m_142700_(consumer, this.modResource("aluminum_ingot_from_blasting_aluminum_ore"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.raw_aluminum.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.aluminum_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.aluminum_ingot.get()))).m_142700_(consumer, this.modResource("aluminum_ingot_from_smelting_raw_aluminum"));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.raw_aluminum.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.aluminum_ingot.get()), (float)0.5f, (int)100).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.aluminum_ingot.get()))).m_142700_(consumer, this.modResource("aluminum_ingot_from_blasting_raw_aluminum"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(TinkersReforgedTags.Items.KEPU_ORE), (ItemLike)((ItemLike)TinkersReforgedItems.kepu_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.kepu_ingot.get()))).m_142700_(consumer, this.modResource("kepu_ingot_from_smelting_kepu_ore"));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_204132_(TinkersReforgedTags.Items.KEPU_ORE), (ItemLike)((ItemLike)TinkersReforgedItems.kepu_ingot.get()), (float)0.5f, (int)100).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.kepu_ingot.get()))).m_142700_(consumer, this.modResource("kepu_ingot_from_blasting_kepu_ore"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.raw_kepu.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.kepu_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.kepu_ingot.get()))).m_142700_(consumer, this.modResource("kepu_ingot_from_smelting_raw_kepu"));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.raw_kepu.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.kepu_ingot.get()), (float)0.5f, (int)100).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.kepu_ingot.get()))).m_142700_(consumer, this.modResource("kepu_ingot_from_blasting_raw_kepu"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.kepu_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.kepu_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.kepu_ingot.get()))).m_142700_(consumer, this.modResource("kepu_ingot_from_smelting_kepu_dust"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.aluminum_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.aluminum_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.aluminum_ingot.get()))).m_142700_(consumer, this.modResource("aluminum_ingot_from_smelting_aluminum_dust"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.duralumin_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.duralumin_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.duralumin_ingot.get()))).m_142700_(consumer, this.modResource("duralumin_ingot_from_smelting_duralumin_dust"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.lavium_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.lavium_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.lavium_ingot.get()))).m_142700_(consumer, this.modResource("lavium_ingot_from_smelting_lavium_dust"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.qivium_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.qivium_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.qivium_ingot.get()))).m_142700_(consumer, this.modResource("qivium_ingot_from_smelting_qivium_dust"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.gausum_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.gausum_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.gausum_ingot.get()))).m_142700_(consumer, this.modResource("gausum_ingot_from_smelting_gausum_dust"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.felsteel_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.felsteel_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.felsteel_ingot.get()))).m_142700_(consumer, this.modResource("felsteel_ingot_from_smelting_felsteel_dust"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.electrical_copper_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.electrical_copper_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.electrical_copper_ingot.get()))).m_142700_(consumer, this.modResource("electrical_copper_ingot_from_smelting_electrical_copper_dust"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.durasteel_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.durasteel_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.durasteel_ingot.get()))).m_142700_(consumer, this.modResource("durasteel_ingot_from_smelting_durasteel_dust"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.crusteel_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.crusteel_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.crusteel_ingot.get()))).m_142700_(consumer, this.modResource("crusteel_ingot_from_smelting_crusteel_dust"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.wavy_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.wavy_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.wavy_ingot.get()))).m_142700_(consumer, this.modResource("wavy_ingot_from_smelting_wavy_dust"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkersReforgedItems.yokel_dust.get()}), (ItemLike)((ItemLike)TinkersReforgedItems.yokel_ingot.get()), (float)0.0f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)((ItemLike)TinkersReforgedItems.yokel_ingot.get()))).m_142700_(consumer, this.modResource("yokel_ingot_from_smelting_yokel_dust"));
        this.toolBuilding(consumer, (Supplier)TinkersReforgedItems.FRYING_PAN, toolFolder);
        this.toolBuilding(consumer, (Supplier)TinkersReforgedItems.GREATSWORD, toolFolder);
        this.partRecipes(consumer, (IMaterialItem)TinkersReforgedItems.GREAT_BLADE.get(), TinkersReforgedItems.great_blade_cast, 4, partFolder, castFolder);
        this.partRecipes(consumer, (IMaterialItem)TinkersReforgedItems.LARGE_ROUND_PLATE.get(), TinkersReforgedItems.large_round_plate_cast, 6, partFolder, castFolder);
    }

    @Nonnull
    public String getModId() {
        return "tinkers_reforged";
    }

    private void metalComposite(Consumer<FinishedRecipe> consumer, Item input, Item output, FluidObject<?> fluid, boolean forgeTag, String folder, String name) {
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)output).setFluidAndTime(fluid, forgeTag, 90).setCast((ItemLike)input, true).setSwitchSlots().save(consumer, this.modResource(folder + "/metal/" + name));
    }

    private void metalComposite(Consumer<FinishedRecipe> consumer, Block input, Item output, FluidObject<?> fluid, boolean forgeTag, String folder, String name) {
        ItemCastingRecipeBuilder.basinRecipe((ItemLike)output).setFluidAndTime(fluid, forgeTag, 1000).setCast((ItemLike)input, true).setSwitchSlots().save(consumer, this.modResource(folder + "/metal/" + name));
    }

    public void createCast(Consumer<FinishedRecipe> consumer, CastType type, IMaterialItem part, String folder) {
        Item cast = (Item)TinkersReforgedItems.casts.get((Object)type).get();
        this.createCast(consumer, cast, (Ingredient)MaterialIngredient.fromItem((IMaterialItem)part), folder);
    }

    public void createCast(Consumer<FinishedRecipe> consumer, CastType type, String input, String folder) {
        this.createCast(consumer, type, (TagKey<Item>)this.getItemTag("forge", input), folder);
    }

    public void createCast(Consumer<FinishedRecipe> consumer, CastType type, TagKey<Item> input, String folder) {
        Item cast = (Item)TinkersReforgedItems.casts.get((Object)type).get();
        this.createCast(consumer, cast, Ingredient.m_204132_(input), folder);
    }

    public void createCast(Consumer<FinishedRecipe> consumer, Item cast, Ingredient input, String folder) {
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)cast).setFluidAndTime(TinkerFluids.moltenAluminum, true, 90).setCast(input, true).setSwitchSlots().save(consumer, this.modResource(folder + "aluminum_casts/" + cast.getRegistryName().m_135815_()));
    }

    public void blockIngotNuggetCompression(Consumer<FinishedRecipe> consumer, String name, Item block, Item ingot, Item nugget) {
        ConditionalRecipe.builder().addCondition(this.TRUE()).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)1).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.create((ResourceLocation)new ResourceLocation("forge:ingots/" + name))).m_126127_(Character.valueOf('Y'), (ItemLike)ingot).m_142409_("").m_142284_("has_ingot", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)ingot))).m_176498_(arg_0)).generateAdvancement().build(consumer, new ResourceLocation("tinkers_reforged", ingot.getRegistryName().m_135815_() + "_to_block"));
        ConditionalRecipe.builder().addCondition(this.TRUE()).addRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)ingot, (int)9).m_126209_((ItemLike)block).m_142409_("").m_142284_("has_block", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)block))).m_176498_(arg_0)).generateAdvancement().build(consumer, new ResourceLocation("tinkers_reforged", block.getRegistryName().m_135815_() + "_to_ingot"));
        ConditionalRecipe.builder().addCondition(this.TRUE()).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126118_((ItemLike)ingot, (int)1).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.create((ResourceLocation)new ResourceLocation("forge:nuggets/" + name))).m_126127_(Character.valueOf('Y'), (ItemLike)nugget).m_142409_("").m_142284_("has_nugget", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)nugget))).m_176498_(arg_0)).generateAdvancement().build(consumer, new ResourceLocation("tinkers_reforged", nugget.getRegistryName().m_135815_() + "_to_ingot"));
        ConditionalRecipe.builder().addCondition(this.TRUE()).addRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)nugget, (int)9).m_126209_((ItemLike)ingot).m_142409_("").m_142284_("has_ingot", (CriterionTriggerInstance)ReforgedRecipes.m_125977_((ItemLike)ingot))).m_176498_(arg_0)).generateAdvancement().build(consumer, new ResourceLocation("tinkers_reforged", ingot.getRegistryName().m_135815_() + "_to_nugget"));
    }

    private void partRecipes(Consumer<FinishedRecipe> consumer, IMaterialItem part, CastObject cast, int cost, String partFolder, String castFolder) {
        String name = Objects.requireNonNull(part.m_5456_().getRegistryName()).m_135815_();
        PartRecipeBuilder.partRecipe((IMaterialItem)part).setPattern(this.modResource(name)).setPatternItem(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)TinkerTags.Items.DEFAULT_PATTERNS), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)cast.getGoldCast().get()})})).setCost(cost).save(consumer, this.modResource(partFolder + "builder/" + name));
        String castingFolder = partFolder + "casting/";
        MaterialCastingRecipeBuilder.tableRecipe((IMaterialItem)part).setItemCost(cost).setCast(cast.getMultiUseTag(), false).save(consumer, this.modResource(castingFolder + name + "_gold_cast"));
        MaterialCastingRecipeBuilder.tableRecipe((IMaterialItem)part).setItemCost(cost).setCast(cast.getSingleUseTag(), true).save(consumer, this.modResource(castingFolder + name + "_sand_cast"));
        CompositeCastingRecipeBuilder.table((IMaterialItem)part, (int)cost).save(consumer, this.modResource(castingFolder + name + "_composite"));
        MaterialIngredient ingredient = MaterialIngredient.fromItem((IMaterialItem)part);
        this.castCreation(consumer, (Ingredient)ingredient, cast, castFolder, Objects.requireNonNull(part.m_5456_().getRegistryName()).m_135815_());
    }

    private void castCreation(Consumer<FinishedRecipe> consumer, Ingredient input, CastObject cast, String folder, String name) {
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)cast.getGoldCast().get())).setFluidAndTime(TinkerFluids.moltenGold, true, 90).setCast(input, true).setSwitchSlots().save(consumer, this.modResource(folder + "gold_casts/" + name));
        MoldingRecipeBuilder.moldingTable((ItemLike)((ItemLike)cast.getSandCast().get())).setMaterial((ItemLike)TinkerSmeltery.blankSandCast).setPattern(input, false).save(consumer, this.modResource(folder + "sand_casts/" + name));
        MoldingRecipeBuilder.moldingTable((ItemLike)((ItemLike)cast.getRedSandCast().get())).setMaterial((ItemLike)TinkerSmeltery.blankRedSandCast).setPattern(input, false).save(consumer, this.modResource(folder + "red_sand_casts/" + name));
    }
}

